﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;

namespace CRR_Example_Client
{
    public partial class frmKeyManagement : Form
    {
        private RSACryptoServiceProvider PrivateKey = null;
        private RSACryptoServiceProvider PublicKey = null;

        public frmKeyManagement()
        {
            InitializeComponent();
        }

        private void frmKeyManagement_Load(object sender, EventArgs e)
        {
            PrivateKey = SecurityRSA.PrivateKeyForSigningRequests;
            PublicKey = SecurityRSA.PublicKeyForValidatingAnswers;

            txtPrivateKeyPEM.Text = SecurityRSA.OurPrivateKeyPEM;
            txtPublicCertificatesPEM.Text = SecurityRSA.TheirPublicCertificatePEM;

            if (PrivateKey != null)
            {
                txtPrivateKeyMod.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).Modulus);
                txtPrivateKeyExp.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).D);
                txtPrivateKeyPublicExp.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).Exponent);
                txtPrivateKeyP.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).P);
                txtPrivateKeyQ.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).Q);
                txtPrivateKeyDP.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).DP);
                txtPrivateKeyDQ.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).DQ);
                txtPrivateKeyIQ.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).InverseQ);
            }

            if (PublicKey != null)
            {
                txtPublicKeyMod.Text = Misc.ByteArrayToHEX(PublicKey.ExportParameters(false).Modulus);
                txtPublicKeyExp.Text = Misc.ByteArrayToHEX(PublicKey.ExportParameters(false).Exponent);
            }
        }

        private void btnParsePrivateKey_Click(object sender, EventArgs e)
        {
            PrivateKey = SecurityRSA.DecodeRSAPrivateKey(SecurityRSA.GetPem(txtPrivateKeyPEM.Text));

            if (PrivateKey == null)
            {
                txtPrivateKeyMod.Text = "";
                txtPrivateKeyExp.Text = "";
                txtPrivateKeyPublicExp.Text = "";
                txtPrivateKeyP.Text = "";
                txtPrivateKeyQ.Text = "";
                txtPrivateKeyDP.Text = "";
                txtPrivateKeyDQ.Text = "";
                txtPrivateKeyIQ.Text = "";
            }
            else
            {
                RSAParameters public_params = PrivateKey.ExportParameters(false);
                RSAParameters private_params = PrivateKey.ExportParameters(true);

                txtPrivateKeyMod.Text = Misc.ByteArrayToHEX(public_params.Modulus);
                txtPrivateKeyExp.Text = Misc.ByteArrayToHEX(private_params.D);

                txtPrivateKeyMod.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).Modulus);
                txtPrivateKeyExp.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).D);
                txtPrivateKeyPublicExp.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).Exponent);
                txtPrivateKeyP.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).P);
                txtPrivateKeyQ.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).Q);
                txtPrivateKeyDP.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).DP);
                txtPrivateKeyDQ.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).DQ);
                txtPrivateKeyIQ.Text = Misc.ByteArrayToHEX(PrivateKey.ExportParameters(true).InverseQ);
            }
        }

        private void btnParsePublicCertificate_Click(object sender, EventArgs e)
        {
            try
            {
                X509Certificate2 cert = new X509Certificate2(System.Text.UTF8Encoding.UTF8.GetBytes(txtPublicCertificatesPEM.Text));
                RSACryptoServiceProvider RSA = (RSACryptoServiceProvider)cert.PublicKey.Key;
                PublicKey = RSA;
                if (PublicKey != null)
                {
                    txtPublicKeyMod.Text = Misc.ByteArrayToHEX(PublicKey.ExportParameters(false).Modulus);
                    txtPublicKeyExp.Text = Misc.ByteArrayToHEX(PublicKey.ExportParameters(false).Exponent);
                }
            }
            catch { }
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            if (txtPrivateKeyMod.Text.Length % 2 == 1) txtPrivateKeyMod.Text = String.Concat("0", txtPrivateKeyMod.Text);
            if (txtPrivateKeyExp.Text.Length % 2 == 1) txtPrivateKeyExp.Text = String.Concat("0", txtPrivateKeyExp.Text);
            if (txtPrivateKeyPublicExp.Text.Length % 2 == 1) txtPrivateKeyPublicExp.Text = String.Concat("0", txtPrivateKeyPublicExp.Text);
            if (txtPrivateKeyP.Text.Length % 2 == 1) txtPrivateKeyP.Text = String.Concat("0", txtPrivateKeyP.Text);
            if (txtPrivateKeyQ.Text.Length % 2 == 1) txtPrivateKeyQ.Text = String.Concat("0", txtPrivateKeyQ.Text);
            if (txtPrivateKeyDP.Text.Length % 2 == 1) txtPrivateKeyDP.Text = String.Concat("0", txtPrivateKeyDP.Text);
            if (txtPrivateKeyDQ.Text.Length % 2 == 1) txtPrivateKeyDQ.Text = String.Concat("0", txtPrivateKeyDQ.Text);
            if (txtPrivateKeyIQ.Text.Length % 2 == 1) txtPrivateKeyIQ.Text = String.Concat("0", txtPrivateKeyIQ.Text);

            try
            {
                int private_key_size = Math.Max(Math.Max(txtPrivateKeyMod.Text.Length, txtPrivateKeyExp.Text.Length), txtPrivateKeyPublicExp.Text.Length) * 4;

                CspParameters cp = new CspParameters();
                cp.Flags = CspProviderFlags.UseMachineKeyStore;
                cp.KeyContainerName = "CRRKeys";
                PrivateKey = new RSACryptoServiceProvider(private_key_size, cp);

                RSAParameters RSAparams = new RSAParameters();

                RSAparams.Modulus = Misc.HEXToByteArray(txtPrivateKeyMod.Text);
                RSAparams.Exponent = Misc.HEXToByteArray(txtPrivateKeyPublicExp.Text);
                RSAparams.D = Misc.HEXToByteArray(txtPrivateKeyExp.Text);
                RSAparams.P = Misc.HEXToByteArray(txtPrivateKeyP.Text);
                RSAparams.Q = Misc.HEXToByteArray(txtPrivateKeyQ.Text);
                RSAparams.DP = Misc.HEXToByteArray(txtPrivateKeyDP.Text);
                RSAparams.DQ = Misc.HEXToByteArray(txtPrivateKeyDQ.Text);
                RSAparams.InverseQ = Misc.HEXToByteArray(txtPrivateKeyIQ.Text);

                PrivateKey.ImportParameters(RSAparams);
            }
            catch //(Exception ex)
            {
                MessageBox.Show("Private key parameters invalid");
                return;
            }
            // -------------------------------------------------------------------------------------------------
            if (txtPublicKeyMod.Text.Length % 2 == 1)
            {
                txtPublicKeyMod.Text = String.Concat("0", txtPublicKeyMod.Text);
            }
            if (txtPublicKeyExp.Text.Length % 2 == 1)
            {
                txtPublicKeyExp.Text = String.Concat("0", txtPublicKeyExp.Text);
            }

            try
            {
                int public_key_size = Math.Max(txtPublicKeyMod.Text.Length, txtPublicKeyExp.Text.Length) * 4;

                CspParameters cp = new CspParameters();
                cp.Flags = CspProviderFlags.UseMachineKeyStore;
                cp.KeyContainerName = "CRRKeys";
                PublicKey = new RSACryptoServiceProvider(public_key_size, cp);

                RSAParameters RSAparams = new RSAParameters();

                RSAparams.Modulus = Misc.HEXToByteArray(txtPublicKeyMod.Text);
                RSAparams.Exponent = Misc.HEXToByteArray(txtPublicKeyExp.Text);

                PublicKey.ImportParameters(RSAparams);
            }
            catch //(Exception ex)
            {
                MessageBox.Show("Public key parameters invalid");
                return;
            }

            // -------------------------------------------------------------------------------------------------
            SecurityRSA.PrivateKeyForSigningRequests = PrivateKey;
            SecurityRSA.PublicKeyForValidatingAnswers = PublicKey;

            SecurityRSA.OurPrivateKeyPEM = txtPrivateKeyPEM.Text;
            SecurityRSA.TheirPublicCertificatePEM = txtPublicCertificatesPEM.Text;

            DialogResult = System.Windows.Forms.DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.Cancel;
            Close();
        }
    }
}
